<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;
    protected $fillable = array('task', 'priority', 'assigned_to', 'completed_on', 'order');
    protected $visible = array('task', 'priority', 'assigned_to', 'completed_on', 'order');

    public function createdby()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function assingedto()
    {
        return $this->belongsToMany('App\Models\User');
    }

}